/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.cache.model;

import com.google.common.base.Suppliers;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_4588;
import software.bernie.geckolib.cache.model.GeoBone;
import software.bernie.geckolib.loading.json.raw.ModelProperties;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.RenderPassInfo;

public record BakedGeoModel(GeoBone[] topLevelBones, ModelProperties properties, Supplier<Map<String, GeoBone>> boneLookup) {
    public BakedGeoModel(GeoBone[] topLevelBones, ModelProperties properties) {
        this(topLevelBones, properties, BakedGeoModel.createBoneMap(topLevelBones));
    }

    public Optional<GeoBone> getBone(String name) {
        return Optional.ofNullable(this.boneLookup.get().get(name));
    }

    public <R extends GeoRenderState> void render(RenderPassInfo<R> renderPassInfo, class_4588 vertexConsumer, int packedLight, int packedOverlay, int renderColor) {
        for (GeoBone bone : this.topLevelBones()) {
            bone.positionAndRender(renderPassInfo, vertexConsumer, packedLight, packedOverlay, renderColor);
        }
    }

    private static Supplier<Map<String, GeoBone>> createBoneMap(GeoBone[] topLevelBones) {
        return Suppliers.memoize(() -> {
            Object2ReferenceOpenHashMap boneMap = new Object2ReferenceOpenHashMap();
            for (GeoBone bone : topLevelBones) {
                boneMap.put((Object)bone.name(), (Object)bone);
                for (GeoBone child : BakedGeoModel.collectChildBones(bone)) {
                    boneMap.put((Object)child.name(), (Object)child);
                }
            }
            return boneMap;
        });
    }

    private static List<GeoBone> collectChildBones(GeoBone bone) {
        ObjectArrayList bones = new ObjectArrayList();
        for (GeoBone child : bone.children()) {
            bones.add(child);
            bones.addAll(BakedGeoModel.collectChildBones(child));
        }
        return bones;
    }
}

